/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.remapper;

import catserver.server.CatServer;
import catserver.server.remapper.ReflectionTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.specialsource.JarRemapper;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.Type;

public class RemapUtils {
    private static Map<String, Boolean> classNeedRemap = new ConcurrentHashMap<String, Boolean>();
    public static final String NMS_PREFIX = "net/minecraft/server/";
    public static final String NMS_VERSION = CatServer.getNativeVersion();

    public static String reverseMapExternal(Class<?> name) {
        return RemapUtils.reverseMap(name).replace('/', '.');
    }

    public static String reverseMap(Class<?> name) {
        return RemapUtils.reverseMap(Type.getInternalName(name));
    }

    public static String reverseMap(String check) {
        return ReflectionTransformer.classReverseMapping.getOrDefault(check, check);
    }

    public static String mapMethod(Class<?> inst, String name, Class<?> ... parameterTypes) {
        String result = RemapUtils.mapMethodInternal(inst, name, parameterTypes);
        if (result != null) {
            return result;
        }
        return name;
    }

    public static String mapMethodInternal(Class<?> inst, String name, Class<?> ... parameterTypes) {
        String superMethodName;
        String match = RemapUtils.reverseMap(inst) + "/" + name;
        Collection colls = ReflectionTransformer.methodFastMapping.get((Object)match);
        for (String value : colls) {
            String[] str = value.split("\\s+");
            int i = 0;
            for (Type type : Type.getArgumentTypes((String)str[1])) {
                String typename;
                String string = typename = type.getSort() == 9 ? type.getInternalName() : type.getClassName();
                if (i >= parameterTypes.length || !typename.equals(RemapUtils.reverseMapExternal(parameterTypes[i]))) {
                    i = -1;
                    break;
                }
                ++i;
            }
            if (i < parameterTypes.length) continue;
            return (String)ReflectionTransformer.jarMapping.methods.get(value);
        }
        Class<?> superClass = inst.getSuperclass();
        if (superClass != null && (superMethodName = RemapUtils.mapMethodInternal(superClass, name, parameterTypes)) != null) {
            return superMethodName;
        }
        for (Class<?> interfaceClass : inst.getInterfaces()) {
            String superMethodName2 = RemapUtils.mapMethodInternal(interfaceClass, name, parameterTypes);
            if (superMethodName2 == null) continue;
            return superMethodName2;
        }
        return null;
    }

    public static String mapFieldName(Class<?> inst, String name) {
        Class<?> superClass;
        String key = RemapUtils.reverseMap(inst) + "/" + name;
        String mapped = (String)ReflectionTransformer.jarMapping.fields.get(key);
        if (mapped == null && (superClass = inst.getSuperclass()) != null) {
            mapped = RemapUtils.mapFieldName(superClass, name);
        }
        return mapped != null ? mapped : name;
    }

    public static String fixPackageAndMapClass(String className) {
        String remapped = JarRemapper.mapTypeName((String)className, (Map)ReflectionTransformer.jarMapping.packages, (Map)ReflectionTransformer.jarMapping.classes, (String)className);
        if (remapped.equals(className) && className.startsWith(NMS_PREFIX) && !className.contains(NMS_VERSION)) {
            String[] splitStr = className.split("/");
            return JarRemapper.mapTypeName((String)(NMS_PREFIX + NMS_VERSION + "/" + splitStr[splitStr.length - 1]), (Map)ReflectionTransformer.jarMapping.packages, (Map)ReflectionTransformer.jarMapping.classes, (String)className);
        }
        return remapped;
    }

    public static String reverseFiled(Field field) {
        String name = field.getName();
        String match = RemapUtils.reverseMap(field.getDeclaringClass()) + "/";
        Collection colls = ReflectionTransformer.fieldReverseMapping.get((Object)name);
        for (String value : colls) {
            if (!value.startsWith(match)) continue;
            String[] matched = value.split("\\/");
            String rtr = matched[matched.length - 1];
            return rtr;
        }
        return name;
    }

    public static String reverseMethodName(Method method) {
        String name = method.getName();
        String match = RemapUtils.reverseMap(method.getDeclaringClass()) + "/";
        Collection colls = ReflectionTransformer.methodReverseMapping.get((Object)name);
        for (String value : colls) {
            if (!value.startsWith(match)) continue;
            String[] matched = value.split("\\s+")[0].split("\\/");
            String rtr = matched[matched.length - 1];
            return rtr;
        }
        return name;
    }

    public static boolean isNeedRemapClass(Class<?> clazz, boolean checkSuperClass) {
        String className = clazz.getName();
        Boolean cache = classNeedRemap.get(className);
        if (cache != null) {
            return cache;
        }
        while (clazz != null && clazz.getClassLoader() != null) {
            if (clazz.getName().startsWith("net.minecraft.")) {
                classNeedRemap.put(className, true);
                return true;
            }
            if (checkSuperClass) {
                for (Class<?> interfaceClass : clazz.getInterfaces()) {
                    if (!RemapUtils.isNeedRemapClass(interfaceClass, true)) continue;
                    return true;
                }
                clazz = clazz.getSuperclass();
                continue;
            }
            return false;
        }
        classNeedRemap.put(className, false);
        return false;
    }

    public static String fixSimpleName(String originSimpleName, String remappedSimpleName) {
        if (remappedSimpleName.contains("$")) {
            String[] originSplit = originSimpleName.split("\\$");
            String[] remappedSplit = remappedSimpleName.split("\\$");
            int length = remappedSplit.length - originSplit.length;
            if (length > 0) {
                Object[] fixedSplit = new String[originSplit.length];
                System.arraycopy(remappedSplit, length, fixedSplit, 0, fixedSplit.length);
                return StringUtils.join((Object[])fixedSplit, (String)"$");
            }
        }
        return remappedSimpleName;
    }
}

